/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.ComposeReflectionKt;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.agent.Reload;
import org.jetbrains.compose.reload.agent.ReloadHooksKt;
import org.jetbrains.compose.reload.analysis.ClassId;
import org.jetbrains.compose.reload.analysis.ComposeGroupKey;
import org.jetbrains.compose.reload.analysis.MethodId;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInvalidationKey;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInvalidationKeyKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"logger", "Lorg/slf4j/Logger;", "launchComposeGroupInvalidation", "", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\ncomposeGroupInvalidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 composeGroupInvalidation.kt\norg/jetbrains/compose/reload/agent/ComposeGroupInvalidationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/agent/LoggingKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,45:1\n1563#2:46\n1634#2,3:47\n9#3,21:50\n9#3,21:78\n538#4:71\n523#4,6:72\n10#5:99\n*S KotlinDebug\n*F\n+ 1 composeGroupInvalidation.kt\norg/jetbrains/compose/reload/agent/ComposeGroupInvalidationKt\n*L\n35#1:46\n35#1:47,3\n40#1:50,21\n28#1:78,21\n20#1:71\n20#1:72,6\n7#1:99\n*E\n"})
public final class ComposeGroupInvalidationKt {
    @NotNull
    private static final Logger logger;

    public static final void launchComposeGroupInvalidation() {
        ReloadHooksKt.invokeAfterHotReload((Function2<? super UUID, ? super Either<Reload, ? extends Throwable>, Unit>)((Function2)ComposeGroupInvalidationKt::launchComposeGroupInvalidation$lambda$5));
    }

    private static final CharSequence launchComposeGroupInvalidation$lambda$5$lambda$3$lambda$2(MethodId methodId) {
        Intrinsics.checkNotNullParameter((Object)methodId, (String)"methodId");
        return ClassId.toString-impl((String)methodId.getClassId-uSFnFHE()) + "." + methodId.getMethodName();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit launchComposeGroupInvalidation$lambda$5$lambda$3(RuntimeInfo $newRuntime, ComposeGroupKey group, List list) {
        void $this$orchestration_u24default$iv;
        void $this$mapTo$iv$iv;
        Logger $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)list, (String)"<unused var>");
        if (group == null) {
            return Unit.INSTANCE;
        }
        List list2 = (List)$newRuntime.getGroups().get(group);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable iterable = list2;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void scope;
            RuntimeScopeInfo runtimeScopeInfo = (RuntimeScopeInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(scope.getMethodId());
        }
        String methods = CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, ComposeGroupInvalidationKt::launchComposeGroupInvalidation$lambda$5$lambda$3$lambda$2, (int)24, null);
        $this$map$iv = logger;
        String message$iv = "Invalidating group '" + group.unbox-impl() + "' " + methods;
        Object throwable$iv = null;
        boolean $i$f$orchestration = false;
        $this$orchestration_u24default$iv.info(message$iv);
        String packageName$iv = MethodHandles.lookup().lookupClass().getPackageName();
        Intrinsics.checkNotNull((Object)packageName$iv);
        String tag$iv = StringsKt.startsWith$default((String)packageName$iv, (String)"org.jetbrains.compose.reload.agent", (boolean)false, (int)2, null) ? "Agent" : "Runtime";
        String message$iv2 = message$iv;
        OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.LogMessage(tag$iv, message$iv2));
        ComposeReflectionKt.invalidateGroupsWithKey-Uq07tQ0(group.unbox-impl());
        return Unit.INSTANCE;
    }

    private static final void launchComposeGroupInvalidation$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit launchComposeGroupInvalidation$lambda$5(UUID reloadRequestId, Either result) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reloadRequestId, (String)"reloadRequestId");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (TryKt.isFailure((Either)result)) {
            return Unit.INSTANCE;
        }
        RuntimeInfo previousRuntime = ((Reload)((Left)result).getValue()).getPreviousRuntime();
        RuntimeInfo newRuntime = ((Reload)((Left)result).getValue()).getNewRuntime();
        Map $this$filter$iv = newRuntime.getGroups();
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl2 = false;
            ComposeGroupKey group = (ComposeGroupKey)entry.getKey();
            if (group == null) {
                bl = false;
            } else {
                RuntimeScopeInvalidationKey runtimeScopeInvalidationKey = RuntimeScopeInvalidationKeyKt.resolveInvalidationKey-ksgmKwg((RuntimeInfo)previousRuntime, (int)group.unbox-impl());
                if (runtimeScopeInvalidationKey == null) {
                    bl = false;
                } else {
                    long currentInvalidationKey = runtimeScopeInvalidationKey.unbox-impl();
                    RuntimeScopeInvalidationKey runtimeScopeInvalidationKey2 = RuntimeScopeInvalidationKeyKt.resolveInvalidationKey-ksgmKwg((RuntimeInfo)newRuntime, (int)group.unbox-impl());
                    if (runtimeScopeInvalidationKey2 == null) {
                        bl = true;
                    } else {
                        long newInvalidationKey = runtimeScopeInvalidationKey2.unbox-impl();
                        bl = !RuntimeScopeInvalidationKey.equals-impl0((long)currentInvalidationKey, (long)newInvalidationKey);
                    }
                }
            }
            if (!bl) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map invalidations = destination$iv$iv;
        if (invalidations.isEmpty()) {
            void $this$orchestration_u24default$iv;
            $this$filter$iv = logger;
            String message$iv = "All groups retained";
            Object throwable$iv = null;
            boolean $i$f$orchestration = false;
            $this$orchestration_u24default$iv.info(message$iv);
            String packageName$iv = MethodHandles.lookup().lookupClass().getPackageName();
            Intrinsics.checkNotNull((Object)packageName$iv);
            String tag$iv = StringsKt.startsWith$default((String)packageName$iv, (String)"org.jetbrains.compose.reload.agent", (boolean)false, (int)2, null) ? "Agent" : "Runtime";
            String message$iv2 = message$iv;
            OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.LogMessage(tag$iv, message$iv2));
        }
        invalidations.forEach((arg_0, arg_1) -> ComposeGroupInvalidationKt.launchComposeGroupInvalidation$lambda$5$lambda$4((arg_0, arg_1) -> ComposeGroupInvalidationKt.launchComposeGroupInvalidation$lambda$5$lambda$3(newRuntime, arg_0, arg_1), arg_0, arg_1));
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ComposeGroupInvalidationKt.logger = logger;
    }
}

