/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.analysis.RuntimeInfo;
import org.jetbrains.compose.reload.analysis.RuntimeInfoKt;
import org.jetbrains.compose.reload.analysis.RuntimeScopeInfo;
import org.jetbrains.compose.reload.core.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u001a\u0014\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fH\u0000\u001a=\u0010\u000f\u001a\u0012\u0012\u0002\b\u0003 \u0004*\b\u0012\u0002\b\u0003\u0018\u00010\f0\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005\"\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"logger", "Lorg/slf4j/Logger;", "runtimeAnalysisThread", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/ExecutorService;", "currentRuntime", "Ljava/util/ArrayList;", "Lorg/jetbrains/compose/reload/analysis/RuntimeScopeInfo;", "Lkotlin/collections/ArrayList;", "pendingRedefinitions", "redefineRuntimeInfo", "Ljava/util/concurrent/Future;", "Lorg/jetbrains/compose/reload/core/Update;", "Lorg/jetbrains/compose/reload/analysis/RuntimeInfo;", "enqueueRuntimeAnalysis", "className", "", "classBeingRedefined", "Ljava/lang/Class;", "classfileBuffer", "", "(Ljava/lang/String;Ljava/lang/Class;[B)Ljava/util/concurrent/Future;", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nruntimeTracking.kt\nKotlin\n*S Kotlin\n*F\n+ 1 runtimeTracking.kt\norg/jetbrains/compose/reload/agent/RuntimeTrackingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,57:1\n1628#2,3:58\n10#3:61\n*S KotlinDebug\n*F\n+ 1 runtimeTracking.kt\norg/jetbrains/compose/reload/agent/RuntimeTrackingKt\n*L\n24#1:58,3\n11#1:61\n*E\n"})
public final class RuntimeTrackingKt {
    @NotNull
    private static final Logger logger;
    private static final ExecutorService runtimeAnalysisThread;
    @NotNull
    private static final ArrayList<RuntimeScopeInfo> currentRuntime;
    @NotNull
    private static final ArrayList<RuntimeScopeInfo> pendingRedefinitions;

    @NotNull
    public static final Future<Update<RuntimeInfo>> redefineRuntimeInfo() {
        Future<Update<RuntimeInfo>> future = runtimeAnalysisThread.submit(RuntimeTrackingKt::redefineRuntimeInfo$lambda$3);
        Intrinsics.checkNotNullExpressionValue(future, (String)"submit(...)");
        return future;
    }

    public static final Future<?> enqueueRuntimeAnalysis(@Nullable String className, @Nullable Class<?> classBeingRedefined, @NotNull byte[] classfileBuffer) {
        Intrinsics.checkNotNullParameter((Object)classfileBuffer, (String)"classfileBuffer");
        return runtimeAnalysisThread.submit(() -> RuntimeTrackingKt.enqueueRuntimeAnalysis$lambda$4(classfileBuffer, classBeingRedefined, className));
    }

    private static final Thread runtimeAnalysisThread$lambda$0(Runnable r) {
        return ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"Compose Runtime Analyzer", (int)0, (Function0)((Function0)new Function0<Unit>((Object)r){

            public final void invoke() {
                ((Runnable)this.receiver).run();
            }
        }), (int)20, null);
    }

    private static final boolean redefineRuntimeInfo$lambda$3$lambda$2(HashSet $pendingMethodIds, RuntimeScopeInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return $pendingMethodIds.contains(info.getMethodId());
    }

    /*
     * WARNING - void declaration
     */
    private static final Update redefineRuntimeInfo$lambda$3() {
        void var3_2;
        void $this$mapTo$iv;
        List previousRuntimeScopes = CollectionsKt.toList((Iterable)currentRuntime);
        Iterable iterable = pendingRedefinitions;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void info;
            RuntimeScopeInfo runtimeScopeInfo = (RuntimeScopeInfo)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(info.getMethodId());
        }
        HashSet pendingMethodIds = (HashSet)var3_2;
        CollectionsKt.removeAll((List)currentRuntime, arg_0 -> RuntimeTrackingKt.redefineRuntimeInfo$lambda$3$lambda$2(pendingMethodIds, arg_0));
        currentRuntime.addAll((Collection<RuntimeScopeInfo>)pendingRedefinitions);
        pendingRedefinitions.clear();
        return new Update((Object)new RuntimeInfo(previousRuntimeScopes, null, null, 6, null), (Object)new RuntimeInfo(CollectionsKt.toList((Iterable)currentRuntime), null, null, 6, null));
    }

    private static final void enqueueRuntimeAnalysis$lambda$4(byte[] $classfileBuffer, Class $classBeingRedefined, String $className) {
        try {
            boolean bl;
            RuntimeInfo runtimeInfo = RuntimeInfoKt.RuntimeInfo((byte[])$classfileBuffer);
            if (runtimeInfo == null) {
                return;
            }
            RuntimeInfo classInfo = runtimeInfo;
            if ($classBeingRedefined == null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Parsed 'RuntimeInfo' for '" + $className + "'");
                }
                bl = currentRuntime.addAll(classInfo.getScopes());
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Parsed 'RuntimeInfo' for '" + $className + "' (redefined)");
                }
                bl = pendingRedefinitions.addAll(classInfo.getScopes());
            }
        }
        catch (Throwable t) {
            logger.error("Failed parsing 'RuntimeInfo' for '" + $className + "'", t);
        }
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        RuntimeTrackingKt.logger = logger;
        runtimeAnalysisThread = Executors.newSingleThreadExecutor(RuntimeTrackingKt::runtimeAnalysisThread$lambda$0);
        currentRuntime = new ArrayList(16384);
        pendingRedefinitions = new ArrayList(16384);
    }
}

