/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.agent.ComposeHotReloadAgent;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.agent.Reload;
import org.jetbrains.compose.reload.agent.ReloadKt;
import org.jetbrains.compose.reload.core.ClosureKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.EitherKt;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandle;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"logger", "Lorg/slf4j/Logger;", "launchReloadClassesRequestHandler", "", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nreloadClassesRequestHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 reloadClassesRequestHandler.kt\norg/jetbrains/compose/reload/agent/ReloadClassesRequestHandlerKt\n+ 2 OrchestrationHandle.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationHandleKt\n+ 3 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,63:1\n25#2:64\n25#2:65\n10#3:66\n*S KotlinDebug\n*F\n+ 1 reloadClassesRequestHandler.kt\norg/jetbrains/compose/reload/agent/ReloadClassesRequestHandlerKt\n*L\n22#1:64\n53#1:65\n17#1:66\n*E\n"})
public final class ReloadClassesRequestHandlerKt {
    @NotNull
    private static final Logger logger;

    public static final void launchReloadClassesRequestHandler(@NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        Ref.ObjectRef pendingChanges = new Ref.ObjectRef();
        pendingChanges.element = MapsKt.emptyMap();
        OrchestrationHandle $this$invokeWhenReceived$iv = ComposeHotReloadAgent.INSTANCE.getOrchestration();
        boolean $i$f$invokeWhenReceived = false;
        $this$invokeWhenReceived$iv.invokeWhenMessageReceived((Function1)new Function1<OrchestrationMessage, Unit>(pendingChanges, instrumentation){
            final /* synthetic */ Ref.ObjectRef $pendingChanges$inlined;
            final /* synthetic */ Instrumentation $instrumentation$inlined;
            {
                this.$pendingChanges$inlined = objectRef;
                this.$instrumentation$inlined = instrumentation;
            }

            public final void invoke(OrchestrationMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (message instanceof OrchestrationMessage.ReloadClassesRequest) {
                    OrchestrationMessage.ReloadClassesRequest request = (OrchestrationMessage.ReloadClassesRequest)message;
                    boolean bl = false;
                    SwingUtilities.invokeAndWait(new Runnable((Ref.ObjectRef<Map<File, OrchestrationMessage.ReloadClassesRequest.ChangeType>>)this.$pendingChanges$inlined, request, this.$instrumentation$inlined){
                        final /* synthetic */ Ref.ObjectRef<Map<File, OrchestrationMessage.ReloadClassesRequest.ChangeType>> $pendingChanges;
                        final /* synthetic */ OrchestrationMessage.ReloadClassesRequest $request;
                        final /* synthetic */ Instrumentation $instrumentation;
                        {
                            this.$pendingChanges = $pendingChanges;
                            this.$request = $request;
                            this.$instrumentation = $instrumentation;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void run() {
                            Object message$iv;
                            String tag$iv;
                            Logger $this$orchestration_u24default$iv;
                            boolean $i$f$orchestration;
                            Throwable throwable$iv;
                            Object message$iv2;
                            Either result;
                            Object object;
                            this.$pendingChanges.element = MapsKt.plus((Map)((Map)this.$pendingChanges.element), (Map)this.$request.getChangedClassFiles());
                            ComposeHotReloadAgent.INSTANCE.executeBeforeReloadListeners$hot_reload_agent(this.$request.getMessageId());
                            Instrumentation instrumentation = this.$instrumentation;
                            OrchestrationMessage.ReloadClassesRequest reloadClassesRequest = this.$request;
                            Ref.ObjectRef<Map<File, OrchestrationMessage.ReloadClassesRequest.ChangeType>> objectRef = this.$pendingChanges;
                            boolean $i$f$Try = false;
                            try {
                                boolean bl = false;
                                object = (Either)EitherKt.toLeft((Object)ReloadKt.reload(instrumentation, reloadClassesRequest.getMessageId(), (Map)objectRef.element));
                            }
                            catch (Throwable t$iv) {
                                if (t$iv instanceof CancellationException) {
                                    throw t$iv;
                                }
                                object = (Either)EitherKt.toRight((Object)t$iv);
                            }
                            if (TryKt.isSuccess((Either)(result = object))) {
                                instrumentation = ReloadClassesRequestHandlerKt.access$getLogger$p();
                                message$iv2 = "Reloaded classes: " + this.$request.getMessageId();
                                throwable$iv = null;
                                $i$f$orchestration = false;
                                $this$orchestration_u24default$iv.info((String)message$iv2);
                                String packageName$iv = MethodHandles.lookup().lookupClass().getPackageName();
                                Intrinsics.checkNotNull((Object)packageName$iv);
                                String string = ComposeHotReloadAgent.INSTANCE.getClass().getPackageName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
                                tag$iv = StringsKt.startsWith$default((String)packageName$iv, (String)string, (boolean)false, (int)2, null) ? "Agent" : "Runtime";
                                message$iv = message$iv2;
                                OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.LogMessage(tag$iv, (String)message$iv));
                                new OrchestrationMessage.LogMessage("Agent");
                                this.$pendingChanges.element = MapsKt.emptyMap();
                                OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.ReloadClassesResult(this.$request.getMessageId(), true, null, null, 12, null));
                            }
                            if (TryKt.isFailure((Either)result)) {
                                void $this$flatMapTo$iv$iv;
                                void $this$flatMap$iv;
                                Throwable initial$iv;
                                Set set;
                                Iterable $this$withLinearClosure$iv;
                                Object object2;
                                Throwable $this$orchestration$iv;
                                $this$orchestration_u24default$iv = ReloadClassesRequestHandlerKt.access$getLogger$p();
                                message$iv2 = "Failed to reload classes";
                                throwable$iv = TryKt.getException((Right)((Right)result));
                                $i$f$orchestration = false;
                                if (throwable$iv != null) {
                                    $this$orchestration$iv.error((String)message$iv2, throwable$iv);
                                } else {
                                    $this$orchestration$iv.info((String)message$iv2);
                                }
                                String packageName$iv = MethodHandles.lookup().lookupClass().getPackageName();
                                Intrinsics.checkNotNull((Object)packageName$iv);
                                String string = ComposeHotReloadAgent.INSTANCE.getClass().getPackageName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
                                String string2 = tag$iv = StringsKt.startsWith$default((String)packageName$iv, (String)string, (boolean)false, (int)2, null) ? "Agent" : "Runtime";
                                if (throwable$iv == null) {
                                    object2 = message$iv2;
                                } else {
                                    StringBuilder $this$orchestration_u24lambda_u240$iv = t$iv = new StringBuilder();
                                    boolean bl = false;
                                    $this$orchestration_u24lambda_u240$iv.append((String)message$iv2).append('\n');
                                    $this$orchestration_u24lambda_u240$iv.append(ExceptionsKt.stackTraceToString((Throwable)throwable$iv));
                                    object2 = t$iv.toString();
                                }
                                message$iv = object2;
                                OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.LogMessage(tag$iv, (String)message$iv));
                                $this$orchestration$iv = TryKt.getException((Right)((Right)result));
                                String string3 = TryKt.getException((Right)((Right)result)).getMessage();
                                boolean bl = false;
                                UUID uUID = this.$request.getMessageId();
                                boolean $i$f$withLinearClosure = false;
                                void throwable = $this$withLinearClosure$iv;
                                boolean bl2 = false;
                                Throwable throwable2 = throwable.getCause();
                                if (throwable2 == null) {
                                    set = SetsKt.setOf((Object)$this$withLinearClosure$iv);
                                } else {
                                    initial$iv = throwable2;
                                    Set results$iv = ClosureKt.createResultSet$default((int)0, (int)1, null);
                                    results$iv.add($this$withLinearClosure$iv);
                                    Throwable enqueued$iv = initial$iv;
                                    while (enqueued$iv != null && results$iv.add(enqueued$iv)) {
                                        Throwable throwable3 = enqueued$iv;
                                        $i$a$-withLinearClosure-ReloadClassesRequestHandlerKt$launchReloadClassesRequestHandler$1$1$1 = false;
                                        enqueued$iv = throwable3.getCause();
                                    }
                                    set = results$iv;
                                }
                                Collection<E> collection = set;
                                $this$withLinearClosure$iv = collection;
                                boolean $i$f$flatMap = false;
                                initial$iv = $this$flatMap$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$flatMapTo = false;
                                for (E element$iv$iv : $this$flatMapTo$iv$iv) {
                                    Throwable throwable4 = (Throwable)element$iv$iv;
                                    boolean bl3 = false;
                                    StackTraceElement[] stackTraceElementArray = throwable4.getStackTrace();
                                    Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                                    Iterable list$iv$iv = ArraysKt.toList((Object[])stackTraceElementArray);
                                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                                }
                                Collection<E> collection2 = collection = (List)destination$iv$iv;
                                String string4 = string3;
                                boolean bl4 = bl;
                                UUID uUID2 = uUID;
                                OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.ReloadClassesResult(uUID2, bl4, string4, (List)collection2));
                            }
                            ComposeHotReloadAgent.INSTANCE.executeAfterReloadListeners$hot_reload_agent(this.$request.getMessageId(), (Either<Reload, ? extends Throwable>)result);
                        }
                    });
                }
            }
        });
        $this$invokeWhenReceived$iv = ComposeHotReloadAgent.INSTANCE.getOrchestration();
        $i$f$invokeWhenReceived = false;
        $this$invokeWhenReceived$iv.invokeWhenMessageReceived((Function1)new Function1<OrchestrationMessage, Unit>(){

            public final void invoke(OrchestrationMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (message instanceof OrchestrationMessage.ShutdownRequest) {
                    OrchestrationMessage.ShutdownRequest it = (OrchestrationMessage.ShutdownRequest)message;
                    boolean bl = false;
                    ReloadClassesRequestHandlerKt.access$getLogger$p().info("Received shutdown request");
                    System.exit(0);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
            }
        });
        ComposeHotReloadAgent.INSTANCE.getOrchestration().invokeWhenClosed(ReloadClassesRequestHandlerKt::launchReloadClassesRequestHandler$lambda$2);
    }

    private static final Unit launchReloadClassesRequestHandler$lambda$2() {
        logger.info("Application Orchestration closed");
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ReloadClassesRequestHandlerKt.logger = logger;
    }
}

