/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.agent.ComposeHotReloadAgent;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.core.BuildSystem;
import org.jetbrains.compose.reload.core.HotReloadEnvironment;
import org.jetbrains.compose.reload.core.HotReloadProperty;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandle;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\b\u0010\r\u001a\u00020\u000eH\u0000\u001a\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0002\u001a\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a(\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u001a \u0010\u0015\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u001a&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u001a\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010\t\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"logger", "Lorg/slf4j/Logger;", "buildSystem", "Lorg/jetbrains/compose/reload/core/BuildSystem;", "gradleBuildRoot", "", "gradleBuildProject", "gradleBuildTask", "amperBuildRoot", "amperBuildTask", "recompileRequests", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage$RecompileRequest;", "launchRecompiler", "", "takeRecompileRequests", "", "startRecompilerProcess", "", "Ljava/lang/ProcessBuilder;", "(Ljava/lang/ProcessBuilder;)Ljava/lang/Integer;", "createRecompilerProcessBuilder", "orchestrationPort", "createRecompilerGradleCommandLineArgs", "createRecompilerAmperCommandLineArgs", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nrecompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 recompiler.kt\norg/jetbrains/compose/reload/agent/RecompilerKt\n+ 2 OrchestrationHandle.kt\norg/jetbrains/compose/reload/orchestration/OrchestrationHandleKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,257:1\n25#2:258\n1#3:259\n1863#4,2:260\n10#5:262\n*S KotlinDebug\n*F\n+ 1 recompiler.kt\norg/jetbrains/compose/reload/agent/RecompilerKt\n*L\n122#1:258\n110#1:260,2\n19#1:262\n*E\n"})
public final class RecompilerKt {
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final BuildSystem buildSystem;
    @Nullable
    private static final String gradleBuildRoot;
    @Nullable
    private static final String gradleBuildProject;
    @Nullable
    private static final String gradleBuildTask;
    @Nullable
    private static final String amperBuildRoot;
    @Nullable
    private static final String amperBuildTask;
    @NotNull
    private static final LinkedBlockingQueue<OrchestrationMessage.RecompileRequest> recompileRequests;

    public static final void launchRecompiler() {
        ProcessBuilder processBuilder;
        int port = ComposeHotReloadAgent.INSTANCE.getOrchestration().getPort();
        logger.debug("'Compose Recompiler': Using orchestration at '" + port + "'");
        switch (WhenMappings.$EnumSwitchMapping$0[buildSystem.ordinal()]) {
            case 1: {
                String string = amperBuildRoot;
                if (string == null) {
                    boolean bl = false;
                    logger.error("Missing '" + HotReloadProperty.AmperBuildRoot.getKey() + "' property");
                    return;
                }
                String amperBuildRoot = string;
                String string2 = amperBuildTask;
                if (string2 == null) {
                    boolean bl = false;
                    logger.error("Missing '" + HotReloadProperty.AmperBuildTask.getKey() + "' property");
                    return;
                }
                String amperBuildTask = string2;
                processBuilder = RecompilerKt.createRecompilerProcessBuilder(amperBuildRoot, amperBuildTask, port);
                break;
            }
            case 2: {
                String string = gradleBuildRoot;
                if (string == null) {
                    boolean bl = false;
                    logger.error("Missing '" + HotReloadProperty.GradleBuildRoot.getKey() + "' property");
                    return;
                }
                String composeBuildRoot = string;
                String string3 = gradleBuildProject;
                if (string3 == null) {
                    boolean bl = false;
                    logger.error("Missing '" + HotReloadProperty.GradleBuildProject.getKey() + "' property");
                    return;
                }
                String gradleBuildProject = string3;
                String string4 = gradleBuildTask;
                if (string4 == null) {
                    boolean bl = false;
                    logger.error("Missing '" + HotReloadProperty.GradleBuildTask.getKey() + "' property");
                    return;
                }
                String gradleBuildTask = string4;
                processBuilder = RecompilerKt.createRecompilerProcessBuilder(composeBuildRoot, gradleBuildProject, gradleBuildTask, port);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ProcessBuilder processBuilder2 = processBuilder;
        Thread recompilerThread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Recompiler", (int)0, () -> RecompilerKt.launchRecompiler$lambda$6(processBuilder2), (int)23, null);
        OrchestrationHandle $this$invokeWhenReceived$iv = ComposeHotReloadAgent.INSTANCE.getOrchestration();
        boolean $i$f$invokeWhenReceived = false;
        $this$invokeWhenReceived$iv.invokeWhenMessageReceived((Function1)new Function1<OrchestrationMessage, Unit>(){

            public final void invoke(OrchestrationMessage message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (message instanceof OrchestrationMessage.RecompileRequest) {
                    OrchestrationMessage.RecompileRequest value = (OrchestrationMessage.RecompileRequest)message;
                    boolean bl = false;
                    RecompilerKt.access$getRecompileRequests$p().put(value);
                }
            }
        });
        ComposeHotReloadAgent.INSTANCE.getOrchestration().invokeWhenClosed(() -> RecompilerKt.launchRecompiler$lambda$8(recompilerThread));
    }

    private static final List<OrchestrationMessage.RecompileRequest> takeRecompileRequests() {
        List result = new ArrayList();
        while (!((Collection)recompileRequests).isEmpty()) {
            ((Collection)result).add(recompileRequests.poll());
        }
        if (!((Collection)result).isEmpty()) {
            return CollectionsKt.toList((Iterable)result);
        }
        return CollectionsKt.listOf((Object)recompileRequests.take());
    }

    private static final Integer startRecompilerProcess(ProcessBuilder $this$startRecompilerProcess) {
        Integer n;
        Process process = $this$startRecompilerProcess.start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"start(...)");
        Process process2 = process;
        Thread shutdownHook = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> RecompilerKt.startRecompilerProcess$lambda$9(process2), (int)30, null);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"Recompiler Output", (int)0, () -> RecompilerKt.startRecompilerProcess$lambda$11(process2), (int)21, null);
        try {
            n = process2.waitFor();
        }
        catch (InterruptedException interruptedException) {
            logger.debug("'Recompiler': Destroying process");
            process2.destroy();
            if (!process2.waitFor(15L, TimeUnit.SECONDS)) {
                logger.debug("'Recompiler': Force destroying process (Interrupt)");
                process2.destroyForcibly();
            }
            n = null;
        }
        Integer exitCode = n;
        logger.debug("Recompile finished '" + exitCode + "'");
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        return exitCode;
    }

    private static final ProcessBuilder createRecompilerProcessBuilder(String gradleBuildRoot, String gradleBuildProject, String gradleBuildTask, int orchestrationPort) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$createRecompilerProcessBuilder_u24lambda_u2412 = processBuilder = new ProcessBuilder(new String[0]).directory(new File(gradleBuildRoot)).command(RecompilerKt.createRecompilerGradleCommandLineArgs(gradleBuildProject, gradleBuildTask, orchestrationPort));
        boolean bl = false;
        Map<String, String> map = $this$createRecompilerProcessBuilder_u24lambda_u2412.environment();
        Object object = HotReloadEnvironment.INSTANCE.getGradleJavaHome();
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        map.putIfAbsent("JAVA_HOME", (String)object);
        ProcessBuilder processBuilder2 = processBuilder.redirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder2, (String)"redirectErrorStream(...)");
        return processBuilder2;
    }

    private static final ProcessBuilder createRecompilerProcessBuilder(String amperBuildRoot, String amperBuildTask, int orchestrationPort) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$createRecompilerProcessBuilder_u24lambda_u2413 = processBuilder = new ProcessBuilder(new String[0]).directory(new File(amperBuildRoot)).command(RecompilerKt.createRecompilerAmperCommandLineArgs(amperBuildTask));
        boolean bl = false;
        $this$createRecompilerProcessBuilder_u24lambda_u2413.environment().putIfAbsent("COMPOSE_HOT_RELOAD_ORCHESTRATION_PORT", String.valueOf(orchestrationPort));
        ProcessBuilder processBuilder2 = processBuilder.redirectErrorStream(true);
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder2, (String)"redirectErrorStream(...)");
        return processBuilder2;
    }

    private static final List<String> createRecompilerGradleCommandLineArgs(String gradleBuildProject, String gradleBuildTask, int orchestrationPort) {
        String[] stringArray;
        String[] stringArray2;
        if (HotReloadEnvironment.INSTANCE.getGradleJavaHome() == null) {
            logger.warn("Missing '" + HotReloadProperty.GradleJavaHome + "' property. Using system java");
        }
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"win", (boolean)false, (int)2, null)) {
            stringArray2 = new String[]{"cmd", "/c", "start", "gradlew.bat"};
            stringArray = stringArray2;
        } else {
            stringArray2 = new String[]{"./gradlew"};
            stringArray = stringArray2;
        }
        String[] gradleScriptCommand = stringArray;
        String gradleTaskPath = Intrinsics.areEqual((Object)gradleBuildProject, (Object)":") ? ":" + gradleBuildTask : gradleBuildProject + ":" + gradleBuildTask;
        SpreadBuilder spreadBuilder = new SpreadBuilder(8);
        spreadBuilder.addSpread((Object)gradleScriptCommand);
        spreadBuilder.add((Object)gradleTaskPath);
        spreadBuilder.add((Object)"--console=plain");
        spreadBuilder.add((Object)("-D" + HotReloadProperty.OrchestrationPort.getKey() + "=" + orchestrationPort));
        Path path = HotReloadEnvironment.INSTANCE.getGradleJavaHome();
        Object object = "-D" + HotReloadProperty.GradleJavaHome.getKey() + "=" + (path != null ? ((Object)path).toString() : null);
        String string3 = object;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        boolean bl = false;
        boolean bl2 = HotReloadEnvironment.INSTANCE.getGradleJavaHome() != null;
        spreadBuilder2.add(bl2 ? object : null);
        Object it = object = "-t";
        spreadBuilder2 = spreadBuilder;
        boolean bl3 = false;
        bl2 = HotReloadEnvironment.INSTANCE.getGradleBuildContinuous();
        spreadBuilder2.add(bl2 ? object : null);
        it = object = "--priority=low";
        spreadBuilder2 = spreadBuilder;
        boolean bl4 = false;
        bl2 = HotReloadEnvironment.INSTANCE.getGradleBuildContinuous();
        spreadBuilder2.add(bl2 ? object : null);
        it = object = "--no-daemon";
        spreadBuilder2 = spreadBuilder;
        boolean bl5 = false;
        bl2 = HotReloadEnvironment.INSTANCE.getGradleBuildContinuous();
        spreadBuilder2.add(bl2 ? object : null);
        return CollectionsKt.listOfNotNull((Object[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    private static final List<String> createRecompilerAmperCommandLineArgs(String amperBuildTask) {
        String[] stringArray;
        String[] stringArray2;
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"win", (boolean)false, (int)2, null)) {
            stringArray2 = new SpreadBuilder[]{"cmd", "/c", "start", "amper.bat"};
            stringArray = stringArray2;
        } else {
            stringArray2 = new String[]{"./amper"};
            stringArray = stringArray2;
        }
        String[] amperScriptCommand = stringArray;
        stringArray2 = new SpreadBuilder(3);
        stringArray2.addSpread((Object)amperScriptCommand);
        stringArray2.add((Object)"task");
        stringArray2.add((Object)amperBuildTask);
        return CollectionsKt.listOfNotNull((Object[])stringArray2.toArray((Object[])new String[stringArray2.size()]));
    }

    private static final Unit launchRecompiler$lambda$6(ProcessBuilder $processBuilder) {
        logger.debug("'Recompiler' started");
        try {
            if (!HotReloadEnvironment.INSTANCE.getGradleBuildContinuous()) {
                OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.RecompilerReady());
            }
            block2: while (true) {
                List<OrchestrationMessage.RecompileRequest> requests = RecompilerKt.takeRecompileRequests();
                Integer exitCode = RecompilerKt.startRecompilerProcess($processBuilder);
                Iterable $this$forEach$iv = requests;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    Object element$iv = iterator.next();
                    OrchestrationMessage.RecompileRequest request = (OrchestrationMessage.RecompileRequest)element$iv;
                    boolean bl = false;
                    OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.RecompileResult(request.getMessageId(), exitCode));
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            logger.debug("'Recompiler': Interrupted: Shutting down");
            return Unit.INSTANCE;
        }
    }

    private static final Unit launchRecompiler$lambda$8(Thread $recompilerThread) {
        logger.debug("'Compose Recompiler': Sending close signal");
        $recompilerThread.interrupt();
        $recompilerThread.join();
        return Unit.INSTANCE;
    }

    private static final Unit startRecompilerProcess$lambda$9(Process $process) {
        logger.debug("'Recompiler': Destroying process (Shutdown)");
        $process.destroy();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit startRecompilerProcess$lambda$11(Process $process) {
        InputStream inputStream = $process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        object = null;
        try {
            BufferedReader reader2 = (BufferedReader)closeable;
            boolean bl = false;
            while (reader2.readLine() != null) {
                String nextLine;
                logger.debug("'Compose Recompiler' output: " + nextLine);
                OrchestrationKt.send((OrchestrationMessage)new OrchestrationMessage.LogMessage("Compiler", nextLine));
            }
            reader = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ LinkedBlockingQueue access$getRecompileRequests$p() {
        return recompileRequests;
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        RecompilerKt.logger = logger;
        buildSystem = HotReloadEnvironment.INSTANCE.getBuildSystem();
        gradleBuildRoot = HotReloadEnvironment.INSTANCE.getGradleBuildRoot();
        gradleBuildProject = HotReloadEnvironment.INSTANCE.getGradleBuildProject();
        gradleBuildTask = HotReloadEnvironment.INSTANCE.getGradleBuildTask();
        amperBuildRoot = HotReloadEnvironment.INSTANCE.getAmperBuildRoot();
        amperBuildTask = HotReloadEnvironment.INSTANCE.getAmperBuildTask();
        recompileRequests = new LinkedBlockingQueue(CollectionsKt.listOf((Object)new OrchestrationMessage.RecompileRequest()));
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BuildSystem.values().length];
            try {
                nArray[BuildSystem.Amper.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildSystem.Gradle.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

