/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.agent;

import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.agent.ComposeGroupInvalidationKt;
import org.jetbrains.compose.reload.agent.ComposeReflectionKt;
import org.jetbrains.compose.reload.agent.ComposeReloadPremainExtension;
import org.jetbrains.compose.reload.agent.DevToolsKt;
import org.jetbrains.compose.reload.agent.OrchestrationKt;
import org.jetbrains.compose.reload.agent.PidFileKt;
import org.jetbrains.compose.reload.agent.RecompilerKt;
import org.jetbrains.compose.reload.agent.Reload;
import org.jetbrains.compose.reload.agent.ReloadClassesRequestHandlerKt;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.orchestration.Disposable;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandle;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u001f\u001a\u00020 2!\u0010!\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\nJT\u0010\"\u001a\u00020 2L\u0010!\u001aH\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012)\u0012'\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0016\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000f0\u0011J\u0015\u0010#\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b$J3\u0010%\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000b2\u001c\u0010\u0015\u001a\u0018\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0016H\u0000\u00a2\u0006\u0002\b&J\u0006\u0010'\u001a\u00020\u000fJ\u001a\u0010(\u001a\u00020\u000f2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R/\u0010\b\u001a#\u0012\u001f\u0012\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000RZ\u0010\u0010\u001aN\u0012J\u0012H\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012)\u0012'\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0016\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000f0\u00110\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006+"}, d2={"Lorg/jetbrains/compose/reload/agent/ComposeHotReloadAgent;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger$hot_reload_agent", "()Lorg/slf4j/Logger;", "beforeReloadListeners", "", "Lkotlin/Function1;", "Ljava/util/UUID;", "Lkotlin/ParameterName;", "name", "reloadRequestId", "", "afterReloadListeners", "Lkotlin/Function2;", "Lorg/jetbrains/compose/reload/core/Either;", "Lorg/jetbrains/compose/reload/agent/Reload;", "", "result", "Lorg/jetbrains/compose/reload/core/Try;", "instrumentation", "Ljava/lang/instrument/Instrumentation;", "orchestration", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationHandle;", "getOrchestration", "()Lorg/jetbrains/compose/reload/orchestration/OrchestrationHandle;", "orchestration$delegate", "Lkotlin/Lazy;", "invokeBeforeReload", "Lorg/jetbrains/compose/reload/orchestration/Disposable;", "block", "invokeAfterReload", "executeBeforeReloadListeners", "executeBeforeReloadListeners$hot_reload_agent", "executeAfterReloadListeners", "executeAfterReloadListeners$hot_reload_agent", "retryPendingChanges", "premain", "args", "", "hot-reload-agent"})
@SourceDebugExtension(value={"SMAP\nagent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 agent.kt\norg/jetbrains/compose/reload/agent/ComposeHotReloadAgent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 logging.kt\norg/jetbrains/compose/reload/core/LoggingKt\n*L\n1#1,76:1\n1#2:77\n1863#3,2:78\n1863#3,2:80\n1317#4,2:82\n10#5:84\n*S KotlinDebug\n*F\n+ 1 agent.kt\norg/jetbrains/compose/reload/agent/ComposeHotReloadAgent\n*L\n49#1:78,2\n54#1:80,2\n71#1:82,2\n15#1:84\n*E\n"})
public final class ComposeHotReloadAgent {
    @NotNull
    public static final ComposeHotReloadAgent INSTANCE = new ComposeHotReloadAgent();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<Function1<UUID, Unit>> beforeReloadListeners;
    @NotNull
    private static final List<Function2<UUID, Either<Reload, ? extends Throwable>, Unit>> afterReloadListeners;
    @Nullable
    private static volatile Instrumentation instrumentation;
    @NotNull
    private static final Lazy orchestration$delegate;

    private ComposeHotReloadAgent() {
    }

    @NotNull
    public final Logger getLogger$hot_reload_agent() {
        return logger;
    }

    @NotNull
    public final OrchestrationHandle getOrchestration() {
        Lazy lazy = orchestration$delegate;
        return (OrchestrationHandle)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Disposable invokeBeforeReload(@NotNull Function1<? super UUID, Unit> block) {
        Disposable disposable;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        List<Function1<UUID, Unit>> list = beforeReloadListeners;
        synchronized (list) {
            boolean bl = false;
            beforeReloadListeners.add(block);
            disposable = () -> ComposeHotReloadAgent.invokeBeforeReload$lambda$3$lambda$2(block);
        }
        return disposable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Disposable invokeAfterReload(@NotNull Function2<? super UUID, ? super Either<Reload, ? extends Throwable>, Unit> block) {
        Disposable disposable;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        List<Function2<UUID, Either<Reload, ? extends Throwable>, Unit>> list = afterReloadListeners;
        synchronized (list) {
            boolean bl = false;
            afterReloadListeners.add(block);
            disposable = () -> ComposeHotReloadAgent.invokeAfterReload$lambda$6$lambda$5(block);
        }
        return disposable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeBeforeReloadListeners$hot_reload_agent(@NotNull UUID reloadRequestId) {
        List list;
        Intrinsics.checkNotNullParameter((Object)reloadRequestId, (String)"reloadRequestId");
        List<Function1<UUID, Unit>> list2 = beforeReloadListeners;
        synchronized (list2) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)beforeReloadListeners);
        }
        List listeners = list;
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 listener = (Function1)element$iv;
            boolean bl = false;
            listener.invoke((Object)reloadRequestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executeAfterReloadListeners$hot_reload_agent(@NotNull UUID reloadRequestId, @NotNull Either<Reload, ? extends Throwable> result) {
        List list;
        Intrinsics.checkNotNullParameter((Object)reloadRequestId, (String)"reloadRequestId");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        List<Function2<UUID, Either<Reload, ? extends Throwable>, Unit>> list2 = afterReloadListeners;
        synchronized (list2) {
            boolean bl = false;
            list = CollectionsKt.toList((Iterable)afterReloadListeners);
        }
        List listeners = list;
        Iterable $this$forEach$iv = listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function2 listener = (Function2)element$iv;
            boolean bl = false;
            listener.invoke((Object)reloadRequestId, result);
        }
    }

    public final void retryPendingChanges() {
        this.getOrchestration().sendMessage((OrchestrationMessage)new OrchestrationMessage.ReloadClassesRequest(null, 1, null));
    }

    @JvmStatic
    public static final void premain(@Nullable String args, @NotNull Instrumentation instrumentation) {
        Intrinsics.checkNotNullParameter((Object)instrumentation, (String)"instrumentation");
        ComposeHotReloadAgent.instrumentation = instrumentation;
        PidFileKt.createPidFile();
        ComposeReflectionKt.enableComposeHotReloadMode$default(null, 1, null);
        ComposeGroupInvalidationKt.startComposeGroupInvalidationTransformation(instrumentation);
        ReloadClassesRequestHandlerKt.launchReloadClassesRequestHandler(instrumentation);
        RecompilerKt.launchRecompiler();
        DevToolsKt.launchDevtoolsApplication();
        Sequence<ComposeReloadPremainExtension> $this$forEach$iv = ComposeReloadPremainExtension.Companion.load();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ComposeReloadPremainExtension extension = (ComposeReloadPremainExtension)element$iv;
            boolean bl = false;
            extension.premain();
        }
    }

    private static final OrchestrationHandle orchestration_delegate$lambda$0() {
        return OrchestrationKt.startOrchestration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void invokeBeforeReload$lambda$3$lambda$2(Function1 $block) {
        List<Function1<UUID, Unit>> list = beforeReloadListeners;
        synchronized (list) {
            boolean bl = false;
            beforeReloadListeners.remove($block);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void invokeAfterReload$lambda$6$lambda$5(Function2 $block) {
        List<Function2<UUID, Either<Reload, ? extends Throwable>, Unit>> list = afterReloadListeners;
        synchronized (list) {
            boolean bl = false;
            afterReloadListeners.remove($block);
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        boolean $i$f$createLookupLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        ComposeHotReloadAgent.logger = logger;
        beforeReloadListeners = new ArrayList();
        afterReloadListeners = new ArrayList();
        orchestration$delegate = LazyKt.lazy(ComposeHotReloadAgent::orchestration_delegate$lambda$0);
    }
}

